local t = Def.ActorFrame{};
local StatsP2 = GAMESTATE:IsPlayerEnabled(PLAYER_2) and IsStatsVisible(PLAYER_2) and GAMESTATE:GetNumPlayersEnabled() == 1 and not GAMESTATE:IsDemonstration()
local function IsW5Disabled() if PREFSMAN:GetPreference("TimingWindowSecondsW5") == 0 then return true else return false end end
local function TapNoteScore(pn,tns) return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetTapNoteScores(tns) end
local function TapPercentNoteScore(pn,tns) return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetPercentageOfTaps(tns) end

local TabTitle, LeftL, DownL, UpL, RightL, TotalL
local LJR1, LJR2, LJR3, LJR4, LJR5, LJR6, LJR7 -- Left Judgment Results
local DJR1, DJR2, DJR3, DJR4, DJR5, DJR6, DJR7 -- Down Judgment Results
local UJR1, UJR2, UJR3, UJR4, UJR5, UJR6, UJR7 -- Up Judgment Results
local RJR1, RJR2, RJR3, RJR4, RJR5, RJR6, RJR7 -- Right Judgment Results
local TJR1, TJR2, TJR3, TJR4, TJR5, TJR6

local function JudgmentTitleCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_3" then show(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(TabTitle) end
	end
end

-- Title
t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	CommonNormal()..{
		Name="Judgment Title P2";
		InitCommand=cmd(xy,Left()+173,Top()+54;zoom,0.5;maxwidth,568;halign,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("CURRENT JUDGMENTS PER COLUMN"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentTitleCallback) TabTitle=self self:visible(false) end;
	};
};

local function ColumnsLabelCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then hide(LeftL) hide(DownL) hide(UpL) hide(RightL) hide(TotalL) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(LeftL) hide(DownL) hide(UpL) hide(RightL) hide(TotalL) end
		if event.DeviceInput.button == "DeviceButton_3" then show(LeftL) show(DownL) show(UpL) show(RightL) show(TotalL) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(LeftL) hide(DownL) hide(UpL) hide(RightL) hide(TotalL) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(LeftL) hide(DownL) hide(UpL) hide(RightL) hide(TotalL) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(LeftL) hide(DownL) hide(UpL) hide(RightL) hide(TotalL) end
	end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	Miso()..{
		Name="Left Column P2";
		InitCommand=cmd(xy,Left()+50,Top()+132;valign,0;diffuse,PlayerColor(PLAYER_2));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("LEFT"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(ColumnsLabelCallback) LeftL=self self:visible(false) end;
	};
	Miso()..{
		Name="Down Column P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132;valign,0;diffuse,PlayerColor(PLAYER_2));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("DOWN"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(ColumnsLabelCallback) DownL=self self:visible(false) end;
	};
	Miso()..{
		Name="Up Column P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132;valign,0;diffuse,PlayerColor(PLAYER_2));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("UP"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(ColumnsLabelCallback) UpL=self self:visible(false) end;
	};
	Miso()..{
		Name="Right Column P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132;valign,0;diffuse,PlayerColor(PLAYER_2));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("RIGHT"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(ColumnsLabelCallback) RightL=self self:visible(false) end;
	};
	Miso()..{
		Name="Total Row P2";
		InitCommand=cmd(xy,Left()+55+90*4,Top()+132;valign,0;diffuse,PlayerColor(PLAYER_2));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("TOTAL"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(ColumnsLabelCallback) TotalL=self self:visible(false) end;
	};
};

local function LeftJudgmentLabelCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then hide(LJR1) hide(LJR2) hide(LJR3) hide(LJR4) hide(LJR6) hide(LJR7) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(LJR1) hide(LJR2) hide(LJR3) hide(LJR4) hide(LJR6) hide(LJR7) end
		if event.DeviceInput.button == "DeviceButton_3" then show(LJR1) show(LJR2) show(LJR3) show(LJR4) show(LJR6) show(LJR7) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(LJR1) hide(LJR2) hide(LJR3) hide(LJR4) hide(LJR6) hide(LJR7) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(LJR1) hide(LJR2) hide(LJR3) hide(LJR4) hide(LJR6) hide(LJR7) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(LJR1) hide(LJR2) hide(LJR3) hide(LJR4) hide(LJR6) hide(LJR7) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then hide(LJR5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(LJR5) end
			if event.DeviceInput.button == "DeviceButton_3" then show(LJR5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(LJR5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(LJR5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(LJR5) end
		end
	end
end

-- Here will save the counter of each judgment for the Left Column.
local LeftCounter1, LeftCounter2, LeftCounter3, LeftCounter4, LeftCounter5, LeftCounter6 = 0, 0, 0, 0, 0, 0

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	MisoBold()..{
		Name="Left Perfect+ Result P2";
		InitCommand=cmd(xy,Left()+50,Top()+132+32;valign,0;diffuse,color(jColors[1]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(LeftJudgmentLabelCallback) LJR1=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W1' and track == 1 then
						LeftCounter1 = LeftCounter1 + 1
						self:settext(string.format("%04.0f",LeftCounter1))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Left Perfect Result P2";
		InitCommand=cmd(xy,Left()+50,Top()+132+32*2;valign,0;diffuse,color(jColors[2]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(LeftJudgmentLabelCallback) LJR2=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W2' and track == 1 then
						LeftCounter2 = LeftCounter2 + 1
						self:settext(string.format("%04.0f",LeftCounter2))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Left Great Result P2";
		InitCommand=cmd(xy,Left()+50,Top()+132+32*3;valign,0;diffuse,color(jColors[3]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(LeftJudgmentLabelCallback) LJR3=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W3' and track == 1 then
						LeftCounter3 = LeftCounter3 + 1
						self:settext(string.format("%04.0f",LeftCounter3))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Left Good Result P2";
		InitCommand=cmd(xy,Left()+50,Top()+132+32*4;valign,0;diffuse,color(jColors[4]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(LeftJudgmentLabelCallback) LJR4=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W4' and track == 1 then
						LeftCounter4 = LeftCounter4 + 1
						self:settext(string.format("%04.0f",LeftCounter4))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Left Bad Result P2";
		InitCommand=cmd(xy,Left()+50,Top()+132+32*5;valign,0;diffuse,color(jColors[5]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) and not IsW5Disabled() then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(LeftJudgmentLabelCallback) LJR5=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W5' and track == 1 then
						LeftCounter5 = LeftCounter5 + 1
						self:settext(string.format("%04.0f",LeftCounter5))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Left Miss Result P2";
		InitCommand=cmd(xy,Left()+50,Top()+132+32*(IsW5Disabled() and 5 or 6);valign,0;diffuse,color(jColors[6]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(LeftJudgmentLabelCallback) LJR6=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_Miss' and track == 1 then
						LeftCounter6 = LeftCounter6 + 1
						self:settext(string.format("%04.0f",LeftCounter6))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Left Total Result P2";
		InitCommand=cmd(xy,Left()+50,Top()+132+32*7;valign,0;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(LeftJudgmentLabelCallback) LJR7=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local LeftTotal = LeftCounter1 + LeftCounter2 + LeftCounter3 + LeftCounter4 + LeftCounter5 + LeftCounter6
			self:settext(string.format("%04.0f",LeftTotal))
		end;
	};
};

local function DownJudgmentLabelCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then hide(DJR1) hide(DJR2) hide(DJR3) hide(DJR4) hide(DJR6) hide(DJR7) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(DJR1) hide(DJR2) hide(DJR3) hide(DJR4) hide(DJR6) hide(DJR7) end
		if event.DeviceInput.button == "DeviceButton_3" then show(DJR1) show(DJR2) show(DJR3) show(DJR4) show(DJR6) show(DJR7) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(DJR1) hide(DJR2) hide(DJR3) hide(DJR4) hide(DJR6) hide(DJR7) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(DJR1) hide(DJR2) hide(DJR3) hide(DJR4) hide(DJR6) hide(DJR7) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(DJR1) hide(DJR2) hide(DJR3) hide(DJR4) hide(DJR6) hide(DJR7) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then hide(DJR5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(DJR5) end
			if event.DeviceInput.button == "DeviceButton_3" then show(DJR5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(DJR5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(DJR5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(DJR5) end
		end
	end
end

-- Here will save the counter of each judgment for the Down Column.
local DownCounter1, DownCounter2, DownCounter3, DownCounter4, DownCounter5, DownCounter6 = 0, 0, 0, 0, 0, 0

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	MisoBold()..{
		Name="Down Perfect+ Result P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132+32;valign,0;diffuse,color(jColors[1]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(DownJudgmentLabelCallback) DJR1=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W1' and track == 2 then
						DownCounter1 = DownCounter1 + 1
						self:settext(string.format("%04.0f",DownCounter1))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Down Perfect Result P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132+32*2;valign,0;diffuse,color(jColors[2]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(DownJudgmentLabelCallback) DJR2=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W2' and track == 2 then
						DownCounter2 = DownCounter2 + 1
						self:settext(string.format("%04.0f",DownCounter2))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Down Great Result P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132+32*3;valign,0;diffuse,color(jColors[3]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(DownJudgmentLabelCallback) DJR3=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W3' and track == 2 then
						DownCounter3 = DownCounter3 + 1
						self:settext(string.format("%04.0f",DownCounter3))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Down Good Result P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132+32*4;valign,0;diffuse,color(jColors[4]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(DownJudgmentLabelCallback) DJR4=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W4' and track == 2 then
						DownCounter4 = DownCounter4 + 1
						self:settext(string.format("%04.0f",DownCounter4))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Down Bad Result P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132+32*5;valign,0;diffuse,color(jColors[5]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) and not IsW5Disabled() then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(DownJudgmentLabelCallback) DJR5=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W5' and track == 2 then
						DownCounter5 = DownCounter5 + 1
						self:settext(string.format("%04.0f",DownCounter5))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Down Miss Result P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132+32*(IsW5Disabled() and 5 or 6);valign,0;diffuse,color(jColors[6]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(DownJudgmentLabelCallback) DJR6=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_Miss' and track == 2 then
						DownCounter6 = DownCounter6 + 1
						self:settext(string.format("%04.0f",DownCounter6))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Down Total Result P2";
		InitCommand=cmd(xy,Left()+51+90,Top()+132+32*7;valign,0;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(DownJudgmentLabelCallback) DJR7=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local DownTotal = DownCounter1 + DownCounter2 + DownCounter3 + DownCounter4 + DownCounter5 + DownCounter6
			self:settext(string.format("%04.0f",DownTotal))
		end;
	};
};

local function UpJudgmentLabelCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then hide(UJR1) hide(UJR2) hide(UJR3) hide(UJR4) hide(UJR6) hide(UJR7) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(UJR1) hide(UJR2) hide(UJR3) hide(UJR4) hide(UJR6) hide(UJR7) end
		if event.DeviceInput.button == "DeviceButton_3" then show(UJR1) show(UJR2) show(UJR3) show(UJR4) show(UJR6) show(UJR7) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(UJR1) hide(UJR2) hide(UJR3) hide(UJR4) hide(UJR6) hide(UJR7) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(UJR1) hide(UJR2) hide(UJR3) hide(UJR4) hide(UJR6) hide(UJR7) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(UJR1) hide(UJR2) hide(UJR3) hide(UJR4) hide(UJR6) hide(UJR7) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then hide(UJR5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(UJR5) end
			if event.DeviceInput.button == "DeviceButton_3" then show(UJR5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(UJR5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(UJR5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(UJR5) end
		end
	end
end

-- Here will save the counter of each judgment for the Up Column.
local UpCounter1, UpCounter2, UpCounter3, UpCounter4, UpCounter5, UpCounter6 = 0, 0, 0, 0, 0, 0

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	MisoBold()..{
		Name="Up Perfect+ Result P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132+32;valign,0;diffuse,color(jColors[1]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpJudgmentLabelCallback) UJR1=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W1' and track == 3 then
						UpCounter1 = UpCounter1 + 1
						self:settext(string.format("%04.0f",UpCounter1))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Up Perfect Result P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132+32*2;valign,0;diffuse,color(jColors[2]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpJudgmentLabelCallback) UJR2=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W2' and track == 3 then
						UpCounter2 = UpCounter2 + 1
						self:settext(string.format("%04.0f",UpCounter2))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Up Great Result P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132+32*3;valign,0;diffuse,color(jColors[3]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpJudgmentLabelCallback) UJR3=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W3' and track == 3 then
						UpCounter3 = UpCounter3 + 1
						self:settext(string.format("%04.0f",UpCounter3))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Up Good Result P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132+32*4;valign,0;diffuse,color(jColors[4]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpJudgmentLabelCallback) UJR4=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W4' and track == 3 then
						UpCounter4 = UpCounter4 + 1
						self:settext(string.format("%04.0f",UpCounter4))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Up Bad Result P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132+32*5;valign,0;diffuse,color(jColors[5]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) and not IsW5Disabled() then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpJudgmentLabelCallback) UJR5=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W5' and track == 3 then
						UpCounter5 = UpCounter5 + 1
						self:settext(string.format("%04.0f",UpCounter5))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Up Miss Result P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132+32*(IsW5Disabled() and 5 or 6);valign,0;diffuse,color(jColors[6]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpJudgmentLabelCallback) UJR6=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_Miss' and track == 3 then
						UpCounter6 = UpCounter6 + 1
						self:settext(string.format("%04.0f",UpCounter6))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Up Total Result P2";
		InitCommand=cmd(xy,Left()+52+90*2,Top()+132+32*7;valign,0;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(UpJudgmentLabelCallback) UJR7=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local UpTotal = UpCounter1 + UpCounter2 + UpCounter3 + UpCounter4 + UpCounter5 + UpCounter6
			self:settext(string.format("%04.0f",UpTotal))
		end;
	};
};

local function RightJudgmentLabelCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then hide(RJR1) hide(RJR2) hide(RJR3) hide(RJR4) hide(RJR6) hide(RJR7) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(RJR1) hide(RJR2) hide(RJR3) hide(RJR4) hide(RJR6) hide(RJR7) end
		if event.DeviceInput.button == "DeviceButton_3" then show(RJR1) show(RJR2) show(RJR3) show(RJR4) show(RJR6) show(RJR7) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(RJR1) hide(RJR2) hide(RJR3) hide(RJR4) hide(RJR6) hide(RJR7) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(RJR1) hide(RJR2) hide(RJR3) hide(RJR4) hide(RJR6) hide(RJR7) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(RJR1) hide(RJR2) hide(RJR3) hide(RJR4) hide(RJR6) hide(RJR7) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then hide(RJR5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(RJR5) end
			if event.DeviceInput.button == "DeviceButton_3" then show(RJR5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(RJR5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(RJR5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(RJR5) end
		end
	end
end

-- Here will save the counter of each judgment for the Right Column.
local RightCounter1, RightCounter2, RightCounter3, RightCounter4, RightCounter5, RightCounter6 = 0, 0, 0, 0, 0, 0

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	MisoBold()..{
		Name="Right Perfect+ Result P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132+32;valign,0;diffuse,color(jColors[1]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(RightJudgmentLabelCallback) RJR1=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W1' and track == 4 then
						RightCounter1 = RightCounter1 + 1
						self:settext(string.format("%04.0f",RightCounter1))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Right Perfect Result P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132+32*2;valign,0;diffuse,color(jColors[2]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(RightJudgmentLabelCallback) RJR2=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W2' and track == 4 then
						RightCounter2 = RightCounter2 + 1
						self:settext(string.format("%04.0f",RightCounter2))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Right Great Result P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132+32*3;valign,0;diffuse,color(jColors[3]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(RightJudgmentLabelCallback) RJR3=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W3' and track == 4 then
						RightCounter3 = RightCounter3 + 1
						self:settext(string.format("%04.0f",RightCounter3))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Right Good Result P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132+32*4;valign,0;diffuse,color(jColors[4]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(RightJudgmentLabelCallback) RJR4=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W4' and track == 4 then
						RightCounter4 = RightCounter4 + 1
						self:settext(string.format("%04.0f",RightCounter4))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Right Bad Result P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132+32*5;valign,0;diffuse,color(jColors[5]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(RightJudgmentLabelCallback) RJR5=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_W5' and track == 4 then
						RightCounter5 = RightCounter5 + 1
						self:settext(string.format("%04.0f",RightCounter5))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Right Miss Result P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132+32*(IsW5Disabled() and 5 or 6);valign,0;diffuse,color(jColors[6]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(RightJudgmentLabelCallback) RJR6=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local taps = param.Notes
			if taps then
				for track, tapnote in pairs(taps) do
					local tns = tapnote:GetTapNoteResult():GetTapNoteScore()
					if tns == 'TapNoteScore_Miss' and track == 4 then
						RightCounter6 = RightCounter6 + 1
						self:settext(string.format("%04.0f",RightCounter6))
					end
				end
			end
		end;
	};
	MisoBold()..{
		Name="Right Total Result P2";
		InitCommand=cmd(xy,Left()+53+90*3,Top()+132+32*7;valign,0;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(RightJudgmentLabelCallback) RJR7=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local RightTotal = RightCounter1 + RightCounter2 + RightCounter3 + RightCounter4 + RightCounter5 + RightCounter6
			self:settext(string.format("%04.0f",RightTotal))
		end;
	};
};

local function TotalJudgmentResultCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then hide(TJR1) hide(TJR2) hide(TJR3) hide(TJR4) hide(TJR6) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(TJR1) hide(TJR2) hide(TJR3) hide(TJR4) hide(TJR6) end
		if event.DeviceInput.button == "DeviceButton_3" then show(TJR1) show(TJR2) show(TJR3) show(TJR4) show(TJR6) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(TJR1) hide(TJR2) hide(TJR3) hide(TJR4) hide(TJR6) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(TJR1) hide(TJR2) hide(TJR3) hide(TJR4) hide(TJR6) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(TJR1) hide(TJR2) hide(TJR3) hide(TJR4) hide(TJR6) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then hide(TJR5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(TJR5) end
			if event.DeviceInput.button == "DeviceButton_3" then show(TJR5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(TJR5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(TJR5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(TJR5) end
		end
	end
end

-- Here will save the counter of each judgment for the Total Column.
local TotalCounter1, TotalCounter2, TotalCounter3, TotalCounter4, TotalCounter5, TotalCounter6 = 0, 0, 0, 0, 0, 0

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	MisoBold()..{
		Name="Total Perfect+ Result P2";
		InitCommand=cmd(xy,Left()+55+90*4,Top()+132+32;valign,0;diffuse,ColorDarkTone(color(jColors[1])));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TotalJudgmentResultCallback) TJR1=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local TotalWhite = LeftCounter1 + DownCounter1 + UpCounter1 + RightCounter1
			self:settext(string.format("%04.0f",TotalWhite))
		end;
	};
	MisoBold()..{
		Name="Total Perfect Result P2";
		InitCommand=cmd(xy,Left()+55+90*4,Top()+132+32*2;valign,0;diffuse,ColorDarkTone(color(jColors[2])));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TotalJudgmentResultCallback) TJR2=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local TotalPerfect = LeftCounter2 + DownCounter2 + UpCounter2 + RightCounter2
			self:settext(string.format("%04.0f",TotalPerfect))
		end;
	};
	MisoBold()..{
		Name="Total Great Result P2";
		InitCommand=cmd(xy,Left()+55+90*4,Top()+132+32*3;valign,0;diffuse,ColorDarkTone(color(jColors[3])));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TotalJudgmentResultCallback) TJR3=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local TotalGreat = LeftCounter3 + DownCounter3 + UpCounter3 + RightCounter3
			self:settext(string.format("%04.0f",TotalGreat))
		end;
	};
	MisoBold()..{
		Name="Total Good Result P2";
		InitCommand=cmd(xy,Left()+55+90*4,Top()+132+32*4;valign,0;diffuse,ColorDarkTone(color(jColors[4])));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TotalJudgmentResultCallback) TJR4=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local TotalGood = LeftCounter4 + DownCounter4 + UpCounter4 + RightCounter4
			self:settext(string.format("%04.0f",TotalGood))
		end;
	};
	MisoBold()..{
		Name="Total Bad Result P2";
		InitCommand=cmd(xy,Left()+55+90*4,Top()+132+32*5;valign,0;diffuse,ColorDarkTone(color(jColors[5]));visible,false);
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) and not IsW5Disabled() then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TotalJudgmentResultCallback) TJR5=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local TotalBad = LeftCounter5 + DownCounter5 + UpCounter5 + RightCounter5
			self:settext(string.format("%04.0f",TotalBad))
		end;
	};
	MisoBold()..{
		Name="Total Miss Result P2";
		InitCommand=cmd(xy,Left()+55+90*4,Top()+132+32*(IsW5Disabled() and 5 or 6);valign,0;diffuse,ColorDarkTone(color(jColors[6])));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TotalJudgmentResultCallback) TJR6=self self:visible(false) end;
		JudgmentMessageCommand=function(self, param)
			local TotalMiss = LeftCounter6 + DownCounter6 + UpCounter6 + RightCounter6
			self:settext(string.format("%04.0f",TotalMiss))
		end;
	};
};

return t